﻿Imports System.Data.SqlClient
Public Class frmEditStock
    Dim count As Integer
    Dim itemCode(500), itemCategoryId(500), suplierCode(500) As String
    Dim editStockDs, gridDs As New DataSet
    Dim editStockDa, gridDa As SqlDataAdapter
    Private Sub frmEditStock_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            Db_Connection()
            LoadItemCategory()
            LoadSupplier()
            GridDisplay()
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

    End Sub
    Private Sub GridDisplay()
        Try
            gridDs.Reset()
            sql = " SELECT A.CAT_CATEGORYNAME, B.STK_ITEMCODE, C.ITM_ITEMDESC, B.STK_ITEMQTY, D.QTY_TYPE, E.SPL_COMPNAME,B.STK_REMARK FROM ITEM_CATEGORY AS A INNER JOIN ITEMS AS C ON A.CAT_CATEGORYID = C.ITM_CATID INNER JOIN ITEM_STOCK AS B ON B.STK_ITEMCODE = C.ITM_ITEMCODE INNER JOIN QTYPE_MASTER AS D ON D.QTY_CODE = C.ITM_QTYTYPE INNER JOIN SUPPLIER_MASTER AS E ON E.SPL_SPLCODE = B.ITM_DLRCODE WHERE B.IS_DELETE = 0 "
            gridDa = New SqlDataAdapter(sql, Mycn)
            gridDa.Fill(gridDs, DBNAME)
            dgvStockDisplay.DataSource = gridDs.Tables(DBNAME)
            dgvStockDisplay.Columns(0).HeaderText = "Category Name"
            dgvStockDisplay.Columns(1).HeaderText = "Item Code"
            dgvStockDisplay.Columns(2).HeaderText = "Item Name"
            dgvStockDisplay.Columns(3).HeaderText = "Item Quantity "
            dgvStockDisplay.Columns(4).HeaderText = "Quantity Type"
            dgvStockDisplay.Columns(5).HeaderText = "Dealer"
            dgvStockDisplay.Columns(6).HeaderText = "Remark"
            dgvStockDisplay.AllowUserToAddRows = False
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub
    Private Sub LoadItemCategory()
        Try

            'LOAD ITEM CATEGORY
            editStockDs.Reset()
            sql = " SELECT CAT_CATEGORYID, CAT_CATEGORYNAME, CREATED_DATE FROM ITEM_CATEGORY WHERE IS_DELETE = 0  "
            editStockDa = New SqlDataAdapter(sql, Mycn)
            editStockDa.Fill(editStockDs, DBNAME)
            Dim rowCount = editStockDs.Tables(DBNAME).Rows.Count

            cmbCategoryName.Items.Clear()
            For i = 0 To rowCount - 1
                itemCategoryId(i) = editStockDs.Tables(DBNAME).Rows(i).Item(0)
                cmbCategoryName.Items.Add(editStockDs.Tables(DBNAME).Rows(i).Item(1))
            Next
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub
    Private Sub LoadItemCode()
        Try

            'LOAD ITEM NAME
            editStockDs.Reset()
            sql = " SELECT ITM_ITEMCODE, ITM_ITEMDESC, ITM_QTYTYPE FROM ITEMS WHERE ITM_CATID = '" & itemCategoryId(cmbCategoryName.SelectedIndex) & "' AND IS_DELETE = 0 "
            editStockDa = New SqlDataAdapter(sql, Mycn)
            editStockDa.Fill(editStockDs, DBNAME)
            Dim rowCount = editStockDs.Tables(DBNAME).Rows.Count
            cmbItemCode.Items.Clear()
            cmbItemName.Items.Clear()
            For i = 0 To rowCount - 1
                itemCode(i) = editStockDs.Tables(DBNAME).Rows(i).Item(0)
                cmbItemCode.Items.Add(editStockDs.Tables(DBNAME).Rows(i).Item(0))
                cmbItemName.Items.Add(editStockDs.Tables(DBNAME).Rows(i).Item(1))
            Next
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

    Private Sub LoadItemDesc()
        Try
            editStockDs.Reset()
            sql = "SELECT A.ITM_ITEMDESC, B.QTY_TYPE FROM ITEMS AS A LEFT JOIN QTYPE_MASTER AS B ON A.ITM_QTYTYPE = B.QTY_CODE WHERE A.ITM_ITEMCODE = '" & itemCode(cmbItemCode.SelectedIndex) & "' AND A.IS_DELETE =  0"
            editStockDa = New SqlDataAdapter(sql, Mycn)
            editStockDa.Fill(editStockDs, DBNAME)
            Dim rowCount = editStockDs.Tables(DBNAME).Rows.Count
            If rowCount > 0 Then
                cmbItemName.Text = editStockDs.Tables(DBNAME).Rows(0).Item(0)
                txtQtyType.Text = editStockDs.Tables(DBNAME).Rows(0).Item(1)
            End If
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub
    Private Sub LoadSupplier()
        Try
            editStockDs.Reset()
            sql = "SELECT SPL_SPLCODE, SPL_COMPNAME FROM SUPPLIER_MASTER WHERE IS_DELETE = 0 "
            editStockDa = New SqlDataAdapter(sql, Mycn)
            editStockDa.Fill(editStockDs, DBNAME)
            Dim rowCount = editStockDs.Tables(DBNAME).Rows.Count
            For i = 0 To rowCount - 1
                suplierCode(i) = editStockDs.Tables(DBNAME).Rows(i).Item(0)
                cmbSuplier.Items.Add(editStockDs.Tables(DBNAME).Rows(i).Item(1))
            Next
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

    Private Sub clearfield()
        cmbItemCode.Text = ""
        cmbCategoryName.Text = ""
        cmbItemName.Text = ""
        txtQtyType.Text = ""
        txtStkQty.Text = "1"
        txtStkRemark.Text = ""
        cmbCategoryName.Focus()
    End Sub

    Private Sub cmbCategoryName_SelectedIndexChanged_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbCategoryName.SelectedIndexChanged
        LoadItemCode()
    End Sub

    Private Sub cmbItemName_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbItemCode.SelectedIndexChanged
        LoadItemDesc()
    End Sub
    Private Sub dgvStockDisplay_CellDoubleClick(ByVal sender As Object, ByVal e As System.Windows.Forms.DataGridViewCellEventArgs) Handles dgvStockDisplay.CellDoubleClick
        'Try
        Dim i As Integer
        i = dgvStockDisplay.CurrentRow.Index
        cmbCategoryName.Text = dgvStockDisplay.Item(0, i).Value
        cmbItemCode.Text = dgvStockDisplay.Item(1, i).Value
        cmbItemName.Text = dgvStockDisplay.Item(2, i).Value
        txtStkQty.Text = dgvStockDisplay.Item(3, i).Value
        txtQtyType.Text = dgvStockDisplay.Item(4, i).Value
        cmbSuplier.Text = dgvStockDisplay.Item(5, i).Value
        txtStkRemark.Text = dgvStockDisplay.Item(6, i).Value.ToString
        'Catch EX As Exception
        '    MsgBox(EX.Message)
        'End Try
    End Sub

    Private Sub btnUpdate_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnUpdate.Click

        Try
            If dgvStockDisplay.Rows.Count <> 0 Then

                If Trim(cmbCategoryName.Text) <> "" And Trim(txtStkQty.Text) <> "" And Trim(txtQtyType.Text) <> "" And Trim(cmbItemName.Text) <> "" And Trim(cmbItemName.Text) <> "" And Trim(cmbSuplier.Text) <> "" Then

                    editStockDs.Reset()
                    sql = " UPDATE ITEM_STOCK SET STK_ITEMQTY = '" & txtStkQty.Text & "', STK_REMARK = '" & txtStkRemark.Text & "' WHERE STK_ITEMCODE = '" & itemCode(cmbItemCode.SelectedIndex) & "' AND IS_DELETE = 0 "
                    editStockDa = New SqlDataAdapter(sql, Mycn)
                    editStockDa.Fill(editStockDs, DBNAME)
                    GridDisplay()
                    clearfield()
                    MsgBox("Stock Details Updated")
                Else
                    MsgBox("PLEASE FILL ALL REQUIRED FIELS ")

                End If
            Else
                MsgBox("Empty")
            End If
        Catch ex As Exception

            MsgBox(ex.Message)

        End Try
    End Sub

    Private Sub btnCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCancel.Click
        Me.Close()
    End Sub

    Private Sub btnDelete_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDelete.Click
        Try
            editStockDs.Reset()
            sql = "UPDATE ITEM_STOCK SET IS_DELETE = 1 WHERE STK_ITEMCODE = '" & dgvStockDisplay.Item(1, dgvStockDisplay.CurrentRow.Index).Value & "'"
            editStockDa = New SqlDataAdapter(sql, Mycn)
            editStockDa.Fill(editStockDs, DBNAME)
            GridDisplay()

        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub
    Private Sub LoadItemName()
        Try
            editStockDs.Reset()
            sql = "SELECT A.ITM_ITEMCODE, B.QTY_TYPE FROM ITEMS AS A LEFT JOIN QTYPE_MASTER AS B ON A.ITM_QTYTYPE = B.QTY_CODE WHERE A.ITM_ITEMCODE = '" & itemCode(cmbItemName.SelectedIndex) & "' AND A.IS_DELETE =  0"
            editStockDa = New SqlDataAdapter(sql, Mycn)
            editStockDa.Fill(editStockDs, DBNAME)
            Dim rowCount = editStockDs.Tables(DBNAME).Rows.Count
            If rowCount > 0 Then
                cmbItemCode.Text = editStockDs.Tables(DBNAME).Rows(0).Item(0)
                txtQtyType.Text = editStockDs.Tables(DBNAME).Rows(0).Item(1)
            End If
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub
    Private Sub cmbItemName_SelectedIndexChanged_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbItemName.SelectedIndexChanged
        LoadItemName()
    End Sub
End Class